/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.block.DrillPipeBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IAutoFluidEjecting;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.ISerializableTanks;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.SmartSyncTank;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.GasLiftMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.FluidUtils;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class GasLiftBlockEntity
extends AbstractAirHandlingBlockEntity
implements IMinWorkingPressure,
IRedstoneControl<GasLiftBlockEntity>,
ISerializableTanks,
IAutoFluidEjecting,
MenuProvider {
    private static final int INVENTORY_SIZE = 1;
    private static final int MAX_PUMP_RANGE_SQUARED = 225;
    @DescSynced
    @GuiSynced
    private final GasLiftFluidTank tank = new GasLiftFluidTank();
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> this.tank);
    private final ItemStackHandler inventory = new BaseItemStackHandler(this, 1){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.m_41619_() || itemStack.m_41720_() == ((DrillPipeBlock)ModBlocks.DRILL_PIPE.get()).m_5456_();
        }
    };
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    @GuiSynced
    public int currentDepth;
    @GuiSynced
    public final RedstoneController<GasLiftBlockEntity> rsController = new RedstoneController<GasLiftBlockEntity>(this);
    @GuiSynced
    public PumpMode pumpMode = PumpMode.PUMP_EMPTY;
    @GuiSynced
    public Status status = Status.IDLE;
    private int workTimer;
    private Deque<BlockPos> pumpingLake = new ArrayDeque<BlockPos>();

    public GasLiftBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.GAS_LIFT.get(), pos, state, PressureTier.TIER_ONE, 3000, 4);
    }

    @Override
    public boolean canConnectPneumatic(Direction d) {
        return d != Direction.DOWN;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.tank.tick();
    }

    @Override
    public void tickServer() {
        int curCheckingPipe;
        super.tickServer();
        if (this.currentDepth > 0 && (curCheckingPipe = (int)(this.nonNullLevel().m_46467_() % (long)this.currentDepth)) > 0 && !this.isPipe(this.nonNullLevel(), this.m_58899_().m_5484_(Direction.DOWN, curCheckingPipe))) {
            this.currentDepth = curCheckingPipe - 1;
        }
        if (this.rsController.shouldRun() && this.getPressure() >= this.getMinWorkingPressure()) {
            this.workTimer = (int)((float)this.workTimer + this.getSpeedMultiplierFromUpgrades());
            while (this.workTimer > 20) {
                this.workTimer -= 20;
                this.status = Status.IDLE;
                if (this.pumpMode == PumpMode.RETRACT) {
                    this.retractPipes();
                    continue;
                }
                if (this.suckLiquid() || this.tryDigDown()) continue;
                break;
            }
        } else {
            this.status = Status.IDLE;
        }
    }

    private void retractPipes() {
        if (this.currentDepth > 0) {
            this.status = Status.RETRACTING;
            Level level = this.nonNullLevel();
            if (this.isPipe(level, this.m_58899_().m_142082_(0, -this.currentDepth, 0))) {
                BlockPos pos1 = this.m_58899_().m_5484_(Direction.DOWN, this.currentDepth);
                ItemStack toInsert = new ItemStack((ItemLike)level.m_8055_(pos1).m_60734_());
                if (this.inventory.insertItem(0, toInsert, true).m_41619_()) {
                    this.inventory.insertItem(0, toInsert, false);
                    level.m_46961_(pos1, false);
                    this.addAir(-100);
                    --this.currentDepth;
                } else {
                    this.status = Status.IDLE;
                }
            } else {
                --this.currentDepth;
            }
        }
    }

    private boolean tryDigDown() {
        if (this.isUnbreakable(this.m_58899_().m_5484_(Direction.DOWN, this.currentDepth + 1))) {
            this.status = Status.STUCK;
        } else if (this.m_58899_().m_123342_() - this.currentDepth >= this.nonNullLevel().m_141937_()) {
            this.status = Status.DIGGING;
            ++this.currentDepth;
            BlockPos pos1 = this.m_58899_().m_5484_(Direction.DOWN, this.currentDepth);
            Level level = this.nonNullLevel();
            if (!this.isPipe(level, pos1)) {
                ItemStack extracted = this.inventory.extractItem(0, 1, true);
                if (extracted.m_41720_() == ((DrillPipeBlock)ModBlocks.DRILL_PIPE.get()).m_5456_()) {
                    BlockState currentState = level.m_8055_(pos1);
                    BlockState newState = ((BlockItem)extracted.m_41720_()).m_40614_().m_49966_();
                    int airRequired = Math.round(66.66f * currentState.m_60800_((BlockGetter)level, pos1));
                    if (this.airHandler.getAir() > airRequired) {
                        this.inventory.extractItem(0, 1, false);
                        level.m_46961_(pos1, false);
                        level.m_46597_(pos1, newState);
                        this.workTimer = 19;
                        this.addAir(-airRequired);
                    } else {
                        this.status = Status.IDLE;
                        --this.currentDepth;
                    }
                } else {
                    this.status = Status.IDLE;
                    --this.currentDepth;
                }
            }
        } else {
            this.status = Status.IDLE;
        }
        return this.status == Status.DIGGING;
    }

    private boolean isPipe(Level world, BlockPos pos) {
        return world.m_8055_(pos).m_60734_() == ModBlocks.DRILL_PIPE.get();
    }

    private boolean isUnbreakable(BlockPos pos) {
        return this.nonNullLevel().m_8055_(pos).m_60800_((BlockGetter)this.nonNullLevel(), pos) < 0.0f;
    }

    private boolean suckLiquid() {
        BlockPos pos = this.m_58899_().m_5484_(Direction.DOWN, this.currentDepth + 1);
        Level level = this.nonNullLevel();
        FluidState fluidState = level.m_6425_(pos);
        if (fluidState.m_76152_() == Fluids.f_76191_) {
            return false;
        }
        FluidStack fluidStack = new FluidStack(fluidState.m_76152_(), 1000);
        if (this.tank.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) == fluidStack.getAmount()) {
            FluidStack taken;
            if (this.pumpingLake.isEmpty()) {
                this.findLake(fluidStack.getFluid());
            }
            BlockPos curPos = null;
            while (!this.pumpingLake.isEmpty() && !FluidUtils.isSourceFluidBlock(level, curPos = this.pumpingLake.peek(), fluidStack.getFluid())) {
                this.pumpingLake.pop();
            }
            if (curPos != null && (taken = FluidUtils.tryPickupFluid(this.fluidCap, level, curPos, false, IFluidHandler.FluidAction.EXECUTE)).getAmount() == 1000) {
                this.addAir(-100);
                this.status = Status.PUMPING;
            }
        }
        return true;
    }

    private void findLake(Fluid fluid) {
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> pendingPositions = new ArrayDeque<BlockPos>();
        BlockPos thisPos = this.m_58899_().m_5484_(Direction.DOWN, this.currentDepth + 1);
        pendingPositions.add(thisPos);
        result.add(thisPos);
        while (!pendingPositions.isEmpty()) {
            BlockPos checkingPos = (BlockPos)pendingPositions.pop();
            for (Direction d : DirectionUtil.VALUES) {
                BlockPos newPos;
                if (d == Direction.DOWN || !(PneumaticCraftUtils.distBetweenSq(newPos = checkingPos.m_142300_(d), thisPos) <= 225.0) || !FluidUtils.isSourceFluidBlock(this.nonNullLevel(), newPos, fluid) || result.contains(newPos)) continue;
                pendingPositions.add(newPos);
                result.add(newPos);
            }
        }
        this.pumpingLake = result.stream().sorted((o1, o2) -> (int)o2.m_123331_((Vec3i)this.m_58899_()) - (int)o1.m_123331_((Vec3i)this.m_58899_())).collect(Collectors.toCollection(() -> new ArrayDeque(result.size())));
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        try {
            this.pumpMode = PumpMode.valueOf(tag);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public RedstoneController<GasLiftBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public float getMinWorkingPressure() {
        return 0.5f + (float)this.currentDepth * 0.025f;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Items", (Tag)this.inventory.serializeNBT());
        tag.m_128359_("mode", this.pumpMode.toString());
        tag.m_128405_("currentDepth", this.currentDepth);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("Items"));
        if (tag.m_128441_("mode")) {
            this.pumpMode = PumpMode.valueOf(tag.m_128461_("mode"));
        }
        this.currentDepth = tag.m_128451_("currentDepth");
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.inventoryCap;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction facing) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.orEmpty(cap, this.fluidCap);
        }
        return super.getCapability(cap, facing);
    }

    public IFluidTank getTank() {
        return this.tank;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new GasLiftMenu(i, playerInventory, this.m_58899_());
    }

    @Override
    @Nonnull
    public Map<String, PNCFluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"Tank", (Object)this.tank);
    }

    private class GasLiftFluidTank
    extends SmartSyncTank {
        GasLiftFluidTank() {
            super(GasLiftBlockEntity.this, 16000);
        }

        @Override
        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            int inTank = this.fluid.getAmount();
            int amount = GasLiftBlockEntity.this.pumpMode == PumpMode.PUMP_LEAVE_FLUID ? Math.max(0, inTank - 1) : inTank;
            return super.drain(Math.min(maxDrain, amount), action);
        }
    }

    public static enum PumpMode {
        PUMP_EMPTY,
        PUMP_LEAVE_FLUID,
        RETRACT;

    }

    public static enum Status implements ITranslatableEnum
    {
        IDLE("idling"),
        PUMPING("pumping"),
        DIGGING("diggingDown"),
        RETRACTING("retracting"),
        STUCK("stuck");

        private final String desc;

        private Status(String desc) {
            this.desc = desc;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.tab.status.gasLift.action." + this.desc;
        }
    }
}

